/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_C
#define platform_C

/*
 * Platform specific stuff (in this case, for RISC OS)
 */

/*
 * Find out the path of ACME's library
 */
static void FN_Platform_FindLib(void) {
  psLibPath = "ACME_Lib:";
}

/*
 * Convert UNIX-style pathname to system-style pathname
 */
static void FN_Platform_ConvertPath(char *p) {
  int  a = 0;
  char b;

  while((b = p[a]) != 0) {
    if(b == '.') p[a] = '/';
    if(b == '/') p[a] = '.';
    if(b == '?') p[a] = '#';
    if(b == '#') p[a] = '?';
    a++;
  }
}

/* Setting the created files' types */
static void FN_Platform_SetType(char *pnf, int type) {
  int swi_regs[10];

  swi_regs[0] = 18;
  swi_regs[1] = (int) pnf;
  swi_regs[2] = type;
  _kernel_swi(OS_FILE, swi_regs, swi_regs);
}

/* Throwback protocol */
static void FN_Platform_Message(char *psm, int type) {
  int swi_regs[10];

  if(ffPlatform & FUSETHROWBACK) {
    if((ffPlatform & FTHROWBACKON) == 0) {
      /* if this is the first throwback, set it up and send info */
      ffPlatform |= FTHROWBACKON;
      _kernel_swi(DDEUTILS_THROWBACKSTART, swi_regs, swi_regs);
      swi_regs[0] = 0;
      swi_regs[1] = 0;
      swi_regs[2] = (int) pnfTop;
      _kernel_swi(DDEUTILS_THROWBACKSEND, swi_regs, swi_regs);
    }
    /* send throwback message */
    swi_regs[0] = 1;
    swi_regs[1] = 0;
    swi_regs[2] = (int) Context[nContext].pSourceFile;
    swi_regs[3] = Context[nContext].nLines;
    /* convert ACME message type to DDEUtils message type */
    if(type == EWARNING) swi_regs[4] = DDEUTILS_WARNING;
    if(type == EERROR)   swi_regs[4] = DDEUTILS_ERROR;
    if(type == ESERIOUS) swi_regs[4] = DDEUTILS_SERIOUS;
    swi_regs[5] = (int) psm;
    _kernel_swi(DDEUTILS_THROWBACKSEND, swi_regs, swi_regs);
  }

}

/* If throwback was used, de-register now */
static void FN_Platform_Exit(void) {
  int swi_regs[10];

  if(ffPlatform & FTHROWBACKON) {
    _kernel_swi(XDDEUTILS_THROWBACKEND, swi_regs, swi_regs);
    ffPlatform &= ~FTHROWBACKON;
  }
}

#endif
